/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.container;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jtbcore.container.BeanEventListener;
import jtbcore.container.BeanFactory;
import jtbcore.container.ContainerBean;
import jtbcore.container.UrlBean;
import jtbcore.exception.ContainerException;
import jtbcore.util.AppLogger;
import jtbcore.util.BooleanUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.ObjectUtil;
import jtbcore.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectContainer {
    protected static ObjectContainer instance = null;
    protected String path;
    protected Map<String, String> settings = new ConcurrentHashMap<String, String>();
    protected Map<String, UrlBean> urls = new ConcurrentHashMap<String, UrlBean>();
    protected Map<String, ContainerBean> mapBeans = new ConcurrentHashMap<String, ContainerBean>();
    protected Map<String, Boolean> beansStartedInstantiating = new ConcurrentHashMap<String, Boolean>();
    protected Map<String, Object> beansInstantiated = new ConcurrentHashMap<String, Object>();

    public ObjectContainer() {
    }

    public ObjectContainer(String path) {
        this();
        this.path = path;
    }

    public void parseXml() throws ContainerException {
        try {
            this.parseXml(this.path);
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
    }

    public void parseXml(String xmlPath) throws ContainerException, IOException {
        FileInputStream is = new FileInputStream(xmlPath);
        this.parseXml(is);
        is.close();
    }

    public void parseXml(InputStream isXml) throws ContainerException {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder b = dbf.newDocumentBuilder();
            doc = b.parse(isXml);
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
        Node nodeConfig = doc.getFirstChild();
        NodeList nlConfigItems = nodeConfig.getChildNodes();
        int x = 0;
        while (x < nlConfigItems.getLength()) {
            if ("settings".equals(nlConfigItems.item(x).getNodeName())) {
                this.parseSettings(nlConfigItems.item(x));
            }
            ++x;
        }
        x = 0;
        while (x < nlConfigItems.getLength()) {
            if ("beans".equals(nlConfigItems.item(x).getNodeName())) {
                this.parseBeans(nlConfigItems.item(x));
            }
            ++x;
        }
        x = 0;
        while (x < nlConfigItems.getLength()) {
            if ("urls".equals(nlConfigItems.item(x).getNodeName())) {
                this.parseUrls(nlConfigItems.item(x));
            }
            ++x;
        }
    }

    public void doAutostart() throws ContainerException {
        for (String k : this.mapBeans.keySet()) {
            Object o;
            ContainerBean cb = this.mapBeans.get(k);
            if (!cb.isAutoStart().booleanValue() || !((o = this.getBean(cb.getName())) instanceof BeanEventListener)) continue;
            ((BeanEventListener)o).init();
        }
    }

    protected void parseSettings(Node nodeSettings) {
        NodeList props = nodeSettings.getChildNodes();
        int x = 0;
        while (x < props.getLength()) {
            NamedNodeMap m;
            Node name;
            Node p = props.item(x);
            if ("property".equals(p.getNodeName()) && (name = (m = p.getAttributes()).getNamedItem("name")) != null) {
                String propName = name.getNodeValue();
                String propValue = this.nodePropertyValue(p);
                this.settings.put(propName, propValue);
            }
            ++x;
        }
    }

    protected void parseUrls(Node nodeSettings) {
        NodeList props = nodeSettings.getChildNodes();
        int x = 0;
        while (x < props.getLength()) {
            Node p = props.item(x);
            if ("url".equals(p.getNodeName())) {
                NamedNodeMap m = p.getAttributes();
                if (m.getNamedItem("path") == null) {
                    System.err.println("<url>, path not set, skipping..");
                } else if (m.getNamedItem("ref") == null) {
                    System.err.println("<url>, ref not set, skipping..");
                } else {
                    String propPath = m.getNamedItem("path").getNodeValue();
                    String propRef = m.getNamedItem("ref").getNodeValue();
                    UrlBean b = new UrlBean();
                    b.setPath(propPath);
                    b.setRef(propRef);
                    Node nauth = m.getNamedItem("auth");
                    if (nauth != null) {
                        b.setProperty("auth", BooleanUtil.isTrue(nauth.getNodeValue()));
                    }
                    int y = 0;
                    while (y < m.getLength()) {
                        Node urlAttr = m.item(y);
                        if (!(urlAttr.getNodeName() == null || "auth".equals(urlAttr.getNodeName()) || "path".equals(urlAttr.getNodeName()) || "ref".equals(urlAttr.getNodeName()))) {
                            String attrname = urlAttr.getNodeName();
                            String attrval = urlAttr.getNodeValue();
                            b.setProperty(attrname, attrval);
                        }
                        ++y;
                    }
                    if (this.urls.containsKey(propPath)) {
                        System.err.println("Warning, duplicatie path: " + propPath);
                    }
                    this.urls.put(propPath, b);
                }
            }
            ++x;
        }
    }

    protected String nodePropertyValue(Node n) {
        NamedNodeMap m = n.getAttributes();
        String propValue = null;
        Node val = m.getNamedItem("value");
        propValue = val != null ? val.getNodeValue() : n.getTextContent();
        if (propValue != null) {
            propValue = propValue.trim();
        }
        return propValue;
    }

    protected void parseBeans(Node beansParent) throws ContainerException {
        NodeList nlBeans = beansParent.getChildNodes();
        int x = 0;
        while (x < nlBeans.getLength()) {
            if ("bean".equals(nlBeans.item(x).getNodeName())) {
                this.parseBean(nlBeans.item(x));
            }
            ++x;
        }
    }

    protected void parseBean(Node b) throws ContainerException {
        NamedNodeMap attrs = b.getAttributes();
        Boolean autoStart = false;
        String beanName = null;
        String clazz = null;
        String objectFactory = null;
        if (attrs.getNamedItem("name") != null) {
            beanName = attrs.getNamedItem("name").getNodeValue();
        }
        if (attrs.getNamedItem("class") != null) {
            clazz = attrs.getNamedItem("class").getNodeValue();
        }
        if (attrs.getNamedItem("object-factory") != null) {
            objectFactory = attrs.getNamedItem("object-factory").getNodeValue();
        }
        if (attrs.getNamedItem("auto-start") != null) {
            autoStart = BooleanUtil.isTrue(attrs.getNamedItem("auto-start").getNodeValue());
        }
        ContainerBean bean = new ContainerBean();
        bean.setName(beanName);
        bean.setClazz(clazz);
        bean.setObjectFactory(objectFactory);
        bean.setAutoStart(autoStart);
        NodeList nlSub = b.getChildNodes();
        int y = 0;
        while (y < nlSub.getLength()) {
            block26: {
                boolean propNodeHit;
                Node n;
                block27: {
                    n = nlSub.item(y);
                    propNodeHit = false;
                    if ("#text".equals(n.getNodeName()) || "#comment".equals(n.getNodeName())) break block26;
                    if (!"property".equals(n.getNodeName())) break block27;
                    propNodeHit = true;
                    String propertyName = null;
                    String value = null;
                    String ref = null;
                    NamedNodeMap propAttrs = n.getAttributes();
                    if (propAttrs.getNamedItem("name") == null) break block26;
                    propertyName = propAttrs.getNamedItem("name").getNodeValue();
                    value = this.nodePropertyValue(n);
                    if (propAttrs.getNamedItem("ref") != null) {
                        ref = propAttrs.getNamedItem("ref").getNodeValue();
                    }
                    if (propAttrs.getNamedItem("object-factory") != null) {
                        objectFactory = propAttrs.getNamedItem("object-factory").getNodeValue();
                    }
                    NodeList childs = n.getChildNodes();
                    List<String> stringlist = null;
                    int x = 0;
                    while (x < childs.getLength()) {
                        if ("stringlist".equals(childs.item(x).getNodeName())) {
                            stringlist = this.parseStringList(childs.item(x));
                        }
                        ++x;
                    }
                    ContainerBean.Property cbp = new ContainerBean.Property();
                    cbp.setName(propertyName);
                    cbp.setValue(value);
                    cbp.setRef(ref);
                    cbp.setStringlist(stringlist);
                    bean.setSetting(propertyName, cbp);
                }
                if ("constructor".equals(n.getNodeName())) {
                    propNodeHit = true;
                    NodeList nlConstructorProps = n.getChildNodes();
                    int z = 0;
                    while (z < nlConstructorProps.getLength()) {
                        Node n2 = nlConstructorProps.item(z);
                        if ("property".equals(n2.getNodeName())) {
                            String name = null;
                            String type = null;
                            String value = null;
                            String ref = null;
                            NamedNodeMap propAttrs = n2.getAttributes();
                            if (propAttrs.getNamedItem("name") == null) {
                                throw new ContainerException("Error: name not found on property bean \"" + bean.getName() + "\"");
                            }
                            if (propAttrs.getNamedItem("type") == null) {
                                throw new ContainerException("Error: type mandatory on constructor property, bean \"" + bean.getName() + "\"");
                            }
                            name = propAttrs.getNamedItem("name").getNodeValue();
                            type = propAttrs.getNamedItem("type").getNodeValue();
                            value = this.nodePropertyValue(n2);
                            if (propAttrs.getNamedItem("ref") != null) {
                                ref = propAttrs.getNamedItem("ref").getNodeValue();
                            }
                            ContainerBean.Property cbp = new ContainerBean.Property();
                            cbp.setName(name);
                            cbp.setType(type);
                            cbp.setValue(value);
                            cbp.setRef(ref);
                            bean.addConstructorProperty(cbp);
                        }
                        ++z;
                    }
                }
                if ("init-function".equals(n.getNodeName())) {
                    propNodeHit = true;
                    NamedNodeMap ifAttrs = n.getAttributes();
                    String funcName = ifAttrs.getNamedItem("name").getNodeValue();
                    ContainerBean.InitFunction initFunc = new ContainerBean.InitFunction(funcName);
                    NodeList nlInitFuncProps = n.getChildNodes();
                    int z = 0;
                    while (z < nlInitFuncProps.getLength()) {
                        Node n2 = nlInitFuncProps.item(z);
                        if ("property".equals(n2.getNodeName())) {
                            String name = null;
                            String type = null;
                            String value = null;
                            String ref = null;
                            NamedNodeMap propAttrs = n2.getAttributes();
                            if (propAttrs.getNamedItem("name") == null) {
                                throw new ContainerException("Error: name not found on property bean \"" + bean.getName() + "\"");
                            }
                            if (propAttrs.getNamedItem("type") == null) {
                                throw new ContainerException("Error: typenot found on property bean \"" + bean.getName() + "\"");
                            }
                            name = propAttrs.getNamedItem("name").getNodeValue();
                            type = propAttrs.getNamedItem("type").getNodeValue();
                            value = this.nodePropertyValue(n2);
                            if (propAttrs.getNamedItem("ref") != null) {
                                ref = propAttrs.getNamedItem("ref").getNodeValue();
                            }
                            ContainerBean.Property cbp = new ContainerBean.Property();
                            cbp.setName(name);
                            cbp.setType(type);
                            cbp.setValue(value);
                            cbp.setRef(ref);
                            initFunc.addProperty(cbp);
                        }
                        ++z;
                    }
                    bean.addInitFunctions(initFunc);
                }
                if (!propNodeHit) {
                    System.err.println("Unknown node: " + beanName + ": " + n.getNodeName());
                }
            }
            ++y;
        }
        if (this.mapBeans.containsKey(bean.getName())) {
            System.err.println("Warning: overwriting existing bean: " + bean.getName());
        }
        this.mapBeans.put(bean.getName(), bean);
    }

    public List<String> parseStringList(Node n) {
        ArrayList<String> list = new ArrayList<String>();
        Node ntrim = n.getAttributes().getNamedItem("trim");
        boolean autotrim = false;
        if (ntrim != null && BooleanUtil.isTrue(ntrim.getNodeValue()).booleanValue()) {
            autotrim = true;
        }
        NodeList childs = n.getChildNodes();
        int x = 0;
        while (x < childs.getLength()) {
            Node nc = childs.item(x);
            if ("string".equals(nc.getNodeName())) {
                String v = nc.getTextContent();
                if (autotrim) {
                    v = v.trim();
                }
                list.add(v);
            }
            ++x;
        }
        return list;
    }

    public synchronized Object getBean(String name) throws ContainerException {
        if ("this".equals(name)) {
            return this;
        }
        if (!this.beansInstantiated.containsKey(name)) {
            Object bean = this.initBean(name);
            this.beansInstantiated.put(name, bean);
        }
        return this.beansInstantiated.get(name);
    }

    protected Object initBean(String name) throws ContainerException {
        Class<?> clazz;
        AppLogger.log("initBean(" + name + ")");
        if (this.beansStartedInstantiating.containsKey(name)) {
            throw new ContainerException("Bean loop detected: " + name);
        }
        this.beansStartedInstantiating.put(name, true);
        ContainerBean cb = this.mapBeans.get(name);
        if (cb == null) {
            throw new ContainerException("Bean not found: " + name);
        }
        String strClazz = cb.getClazz();
        try {
            clazz = Class.forName(strClazz);
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
        Object obj = null;
        if (cb.hasObjectFactory()) {
            try {
                Class<?> clazzFactory = Class.forName(cb.getObjectFactory());
                BeanFactory bf = (BeanFactory)clazzFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
                obj = bf.createObject();
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        }
        Constructor c = cb.lookupConstructor(clazz);
        if (c == null) {
            throw new ContainerException("Constructor not found for: " + name);
        }
        Object[] params = cb.constructor.asParams();
        try {
            obj = c.newInstance(params);
        }
        catch (Exception e) {
            throw new ContainerException(e);
        }
        Map<String, ContainerBean.Property> props = cb.getSettings();
        for (String propName : props.keySet()) {
            ContainerBean.Property prop = props.get(propName);
            this.setObjectProperty(obj, prop);
        }
        for (ContainerBean.InitFunction func : cb.getInitFunctions()) {
            Method m = func.lookupFunction(clazz);
            if (m == null) {
                throw new ContainerException("Function not found for: " + name + "::" + func.getFunctionName());
            }
            try {
                m.invoke(obj, func.asParams());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ContainerException(ex);
            }
        }
        AppLogger.log("Bean created.. " + name);
        this.beansStartedInstantiating.remove(name);
        return obj;
    }

    public void setObjectProperty(Object obj, ContainerBean.Property prop) throws ContainerException {
        Object val = null;
        boolean setNull = false;
        if (prop.getRef() != null) {
            if (prop.ref.indexOf(46) != -1) {
                String beanname = prop.ref.substring(0, prop.ref.indexOf(46));
                String propname = prop.ref.substring(prop.ref.indexOf(46) + 1);
                Object o = this.getBean(beanname);
                String getFunc = "get" + StringUtil.camelify(propname);
                try {
                    val = o.getClass().getMethod(getFunc, new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    throw new ContainerException("Property \"" + propname + "\" not found for bean \"" + obj.getClass().getName() + "\"");
                }
            } else if ("null".equals(prop.getRef())) {
                val = null;
                setNull = true;
            } else if (prop.getRef().startsWith("config.")) {
                String propName = prop.getRef().substring("config.".length());
                val = this.getProperty(propName);
            } else {
                val = this.getBean(prop.getRef());
            }
        } else {
            val = prop.getStringlist() != null ? prop.getStringlist() : prop.getValue();
        }
        if (!setNull && val == null) {
            throw new ContainerException("Property mapping failed, value not found: " + String.valueOf(obj.getClass()) + "::" + prop.getName());
        }
        String setFunc = "set" + StringUtil.camelify(prop.getName());
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getParameterCount() == 1 && setFunc.equals(m.getName())) {
                if (setNull) {
                    try {
                        Object[] invokeParams = new Object[]{null};
                        m.invoke(obj, invokeParams);
                        return;
                    }
                    catch (Exception e) {
                        throw new ContainerException(e);
                    }
                }
                Parameter[] params = m.getParameters();
                if (params[0].getType().isAssignableFrom(val.getClass())) {
                    try {
                        m.invoke(obj, val);
                        return;
                    }
                    catch (Exception e) {
                        throw new ContainerException(e);
                    }
                }
                try {
                    val = ObjectUtil.castStringToType((String)val, params[0].getType());
                    m.invoke(obj, val);
                    return;
                }
                catch (Exception e) {
                    throw new ContainerException(e);
                }
            }
            ++n2;
        }
        throw new ContainerException("Property mapping failed: " + String.valueOf(obj.getClass()) + "::" + prop.getName());
    }

    public String getProperty(String propName) {
        if (this.settings.containsKey(propName)) {
            return this.settings.get(propName);
        }
        return null;
    }

    public Integer getPropertyInt(String propName) {
        String p = this.getProperty(propName);
        if (p == null) {
            return null;
        }
        return NumberUtil.tryParseInt(p);
    }

    public Boolean getPropertyBool(String propName) {
        String p = this.getProperty(propName);
        if (p == null) {
            return false;
        }
        return BooleanUtil.isTrue(p);
    }

    public static ObjectContainer getInstance() {
        if (instance == null) {
            instance = new ObjectContainer();
        }
        return instance;
    }

    public InputStream getResourceAsInput(String p) {
        InputStream is = this.getClass().getResourceAsStream(p);
        if (is == null) {
            is = p.startsWith("/") ? this.getClass().getResourceAsStream("/src" + p) : this.getClass().getResourceAsStream("/src/" + p);
        }
        return is;
    }

    public static void main(String[] args) {
        try {
            URL u = ObjectContainer.class.getResource("/jtbcore/conf/default.xml");
            ObjectContainer c = ObjectContainer.getInstance();
            c.parseXml(u.getPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

